"""
Created on Wed Sept 25 16:03:29 2019
@author: Jia
"""
import sympy
import numpy as np

# Environmental attenuation factors, which need to be demarcated,the optimal range from 3.25 to 4.5
# AttenuationFactor = 3.25
# The value of RSSI at 1m away from the detection equipment, the optimal range is between -45 and -49
# RssiValueAtOneMeter = -46.0
# RssiValueAtOneMeter1 = -46.0
# RssiValueAtOneMeter1 = 46.0
# RssiValueAtOneMeter2 = 47.0
# RssiValueAtOneMeter3 = 46.0




def RSSI_DistanceCalc(rssi, RssiValueAtOneMeter, AttenuationFactor):
    p = (RssiValueAtOneMeter - rssi) / (10.0 * AttenuationFactor)
    dis = round(np.power(10, p), 4)
    return dis


def SolveEquation(a, b, c):
    """
    (-b + - sqrt( square(b) - 4ac))/2a
    """
    if a == 0:
        return 'error'
    delta = (b ** 2) - (4 * a * c)
    if delta == 0:
        x = -b / (a * 2)
        return x
    elif delta > 0:
        x1 = (-b + np.sqrt(delta)) / (a * 2)
        x2 = (-b - np.sqrt(delta)) / (a * 2)
        return [x1, x2]
    else:
        return 'no solutions'


def CircleIntersection(X1, Y1, X2, Y2, R1, R2):
    """
    Calculate the coordinates of the intersection of two circles
    (x-X1)**2 + (y-Y1)**2 = (R1)**2                           --Equation 1
    (x-X2)**2 + (y-Y2)**2 = (R2)**2                           --Equation 2

    Equation 1 - Equation 2
    -->  y = ((X2 - X1) / (Y1 - Y2))x + (X1**2 - X2**2 + Y1**2 - Y2**2 + R2**2 - R1**2 ) / 2(Y1 - Y2)
    or   x = ((Y2 - Y1) / (X1 - X2))y + (Y1**2 - Y2**2 + X1**2 - x2**2 + R2**2 - R1**2 ) / 2(X1 - X2)

    then substitute y or x into equation 1:
    a * x**2 + b * x + c = 0 or a * y**2 + b * y + c = 0
    solve equations：
    x or y  = (-b ± sqrt( square(b) - 4ac))/2a
    """
    CircleDist = np.sqrt((X1 - X2)**2 + (Y1 - Y2)**2)
    if CircleDist > (R1 + R2) or CircleDist < np.abs(R1 - R2):  # Two circles have no intersection
        return 'no intersection'
    elif X1 != X2:
        '''
        substitute x into equation 1, transform to : ay**2 + by + c = 0 
        '''
        k = (Y2 - Y1) / (X1 - X2)
        D = ((X1 ** 2) - (X2 ** 2) + (Y1 ** 2) - (Y2 ** 2) + (R2 ** 2) - (R1 ** 2)) / ((X1 - X2) * 2)
        a = 1 + k ** 2
        b = 2 * (k * (D - X1) - Y1)
        c = ((D - X1) ** 2) + (Y1 ** 2) - (R1 ** 2)
        y = SolveEquation(a, b, c)
        if isinstance(y, str):
            return y
        else:
            x1 = y[0] * k + D
            x2 = y[1] * k + D
            return [[x1, y[0]], [x2, y[1]]]
    elif Y1 != Y2:
        # substitute y into equation 1, transform to : ax**2 + bx + c = 0
        k = (X2 - X1) / (Y1 - Y2)
        D = ((X1 ** 2) - (X2 ** 2) + (Y1 ** 2) - (Y2 ** 2) + (R2 ** 2) - (R1 ** 2)) / ((Y1 - Y2) * 2)
        a = 1 + k ** 2
        b = 2 * (k * (D - Y1) - X1)
        c = ((D - Y1) ** 2) + (X1 ** 2) - (R1 ** 2)
        x = SolveEquation(a, b, c)
        if isinstance(x, str):
            return x
        else:
            y1 = x[0] * k + D
            y2 = x[1] * k + D
            return [[x[0], y1], [x[1], y2]]
    else:
        return 'coincides with the center of the circle'


def triposition1(X1, Y1, R1, X2, Y2, R2, X3, Y3, R3):
    """
    triangle positioning algorithm
    (x-X1)**2 + (y-Y1)**2 = (R1)**2                           --Equation 1
    (x-X2)**2 + (y-Y2)**2 = (R2)**2                           --Equation 2
    (x-X3)**2 + (y-Y3)**2 = (R3)**2                           --Equation 3

    From the first equation, subtract the last equation, then take the matrix form: AX=b
    X = A^T * b / (A^T * A)
    """
    # Initialization of the vector matrix B
    vec_b1 = X1**2 - X3**2 + Y1**2 - Y3**2 + R3**2 - R1**2
    vec_b2 = X2**2 - X3**2 + Y2**2 - Y3**2 + R3**2 - R2**2
    vectorB = np.array([vec_b1, vec_b2])
    # Initialization of the coefficient matrix A
    matrixA = np.array([[(2 * (X1-X3)), (2 * (Y1-Y3))], [(2 * (X2-X3)), (2 * (Y2-Y3))]])

    temp_matrix = np.dot(matrixA.T, matrixA)
    result_xy = np.dot(np.linalg.inv(temp_matrix), np.dot(matrixA.T, vectorB))

    return [result_xy[0], result_xy[1]]


def triposition2(X1, Y1, R1, X2, Y2, R2, X3, Y3, R3):
    """
    Every two formulas are combined to calculate and be solved,
    and the solution is the intersection point of the circle with X and Y as the center and R as the radius,
    and the appropriate position is selected from all the intersection points

    then solve the equation above
    """
    temp_x = [X1, X2, X3]
    temp_y = [Y1, Y2, Y3]
    temp_r = [R1, R2, R3]
    for i in [[0, 1], [1, 2], [0, 2]]:
        temp_s = CircleIntersection(temp_x[i[0]], temp_y[i[0]],
                                    temp_x[i[1]], temp_y[i[1]],
                                    temp_r[i[0]], temp_r[i[1]])
        # if not isinstance(temp_s, str):

def tri_weight_position(XArray, YArray, RArray):
    """
    All anchors are divided three as a group to calculate the coordinates,
    Add weight to coordinates every group calculated, like below
    (x,y) = sum(Wight_n * (x',y')/sum(Wight_n)
    then finale coordinate value is calculated
    """
    combination_list = [(0, 1, 2), (0, 1, 3), (0, 2, 3), (1, 2, 3)]
    total_weight = 0.0
    result_x = 0.0
    result_y = 0.0
    temp_weight = 0.0

    for index in combination_list:
        # calculate x',y' by using 3 anchor
        [temp_x, temp_y] = triposition1(XArray[index[0]], YArray[index[0]], RArray[index[0]],
                                        XArray[index[1]], YArray[index[1]], RArray[index[1]],
                                        XArray[index[2]], YArray[index[2]], RArray[index[2]])
        # calculate Weight_n
        temp_weight = (1.0/RArray[index[0]]) + (1.0/RArray[index[1]]) + (1.0/RArray[index[2]])
        # sum(Wight_n * (x',y')
        result_x += temp_x * temp_weight
        result_y += temp_y * temp_weight
        # sum(Wight_n)
        total_weight += temp_weight

    # Finale x,y
    return [result_x/total_weight, result_y/total_weight]
